/*
 * EEPROM Read
 *
 * Reads the value of each byte of the EEPROM and prints it 
 * to the computer.
 * This example code is in the public domain.
 */

#include <EEPROM.h>

// start reading from the first byte (address 0) of the EEPROM
int address = 0;
byte value;

void setup()
{
  // initialize serial and wait for port to open:
  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for Leonardo only
  }

  EepromWrite();
  EepromRead();
}

void EepromWrite(void)
{
  int addr = 0;
  for(addr = 0; addr < 1022; addr++)
  {
    EEPROM.write(addr, addr + 2);
  }
}

void EepromRead(void)
{
  int addr = 0;
  for(addr = 0; addr < 1022; addr++)
  {
    value = EEPROM.read(addr);
    
    Serial.print(addr);
    Serial.print("\t");
    Serial.print(value, DEC);
    Serial.println();
  }
}

void loop()
{

}
